/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: DrvCclsXcConfig.h$
   Last Modification:
    $Id: DrvCclsXcConfig.h 1 2011-09-27 16:14:21Z Eric $

    $Author: Eric $
    $Modtime: 23.01.08 10:16 $
    $Revision: 1 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    CC-Link Slave Driver
    CC-Link Slave driver xC configuration

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
     1          31.10.07    ES
        Created

**************************************************************************************/
#ifndef __DRV_CCLS_XC_CONFIG_H
#define __DRV_CCLS_XC_CONFIG_H

/* External references to the XC codings */
extern TLR_UINT32 XcCode_xpec_cclink_slave0;
extern TLR_UINT32 XcCode_xpec_cclink_slave1;
extern TLR_UINT32 XcCode_xpec_cclink_slave2;
extern TLR_UINT32 XcCode_xpec_cclink_slave3;

extern TLR_UINT32 XcCode_xpec_cclink_slave_rpec0;
extern TLR_UINT32 XcCode_xpec_cclink_slave_rpec1;

extern TLR_UINT32 XcCode_rpu_cclink0;
extern TLR_UINT32 XcCode_rpu_cclink1;
extern TLR_UINT32 XcCode_rpu_cclink2;
extern TLR_UINT32 XcCode_rpu_cclink3;

extern TLR_UINT32 XcCode_tpu_cclink0;
extern TLR_UINT32 XcCode_tpu_cclink1;
extern TLR_UINT32 XcCode_tpu_cclink2;
extern TLR_UINT32 XcCode_tpu_cclink3;

#define XC_CODE_CCS_XPEC0 ((TLR_UINT32 FAR*)&XcCode_xpec_cclink_slave0)
#define XC_CODE_CCS_XPEC1 ((TLR_UINT32 FAR*)&XcCode_xpec_cclink_slave1)
#define XC_CODE_CCS_XPEC2 ((TLR_UINT32 FAR*)&XcCode_xpec_cclink_slave2)
#define XC_CODE_CCS_XPEC3 ((TLR_UINT32 FAR*)&XcCode_xpec_cclink_slave3)

#define XC_CODE_CCS_RPEC0 ((UINT32 FAR*)&XcCode_xpec_cclink_slave_rpec0)
#define XC_CODE_CCS_RPEC1 ((UINT32 FAR*)&XcCode_xpec_cclink_slave_rpec1)

#define XC_CODE_CCS_RPU0 ((TLR_UINT32 FAR*)&XcCode_rpu_cclink0)
#define XC_CODE_CCS_RPU1 ((TLR_UINT32 FAR*)&XcCode_rpu_cclink1)
#define XC_CODE_CCS_RPU2 ((TLR_UINT32 FAR*)&XcCode_rpu_cclink2)
#define XC_CODE_CCS_RPU3 ((TLR_UINT32 FAR*)&XcCode_rpu_cclink3)

#define XC_CODE_CCS_TPU0 ((TLR_UINT32 FAR*)&XcCode_tpu_cclink0)
#define XC_CODE_CCS_TPU1 ((TLR_UINT32 FAR*)&XcCode_tpu_cclink1)
#define XC_CODE_CCS_TPU2 ((TLR_UINT32 FAR*)&XcCode_tpu_cclink2)
#define XC_CODE_CCS_TPU3 ((TLR_UINT32 FAR*)&XcCode_tpu_cclink3)

#endif /* #ifndef __DRV_CCLS_XC_CONFIG_H */

/**************************************************************************************/
/*------------------------------------------------------------------------------------*/
/*-----------------------------EOF----------------------------------------------------*/
/*------------------------------------------------------------------------------------*/
/**************************************************************************************/

